﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultNetworkPlugin.Controls.Strategy
{
    public interface IKeepAliveTimeStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class KeepAliveTimeDefaultStrategy : ICorrespondenceOS, IKeepAliveTimeStrategy
    {
        public KeepAliveTimeDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "KeepAliveTime";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"System\CurrentControlSet\Services\Tcpip\Parameters");

            registryKey.SetValue(RegName, num, RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"System\CurrentControlSet\Services\Tcpip\Parameters");

            return new WFRegistry(@"HKEY LOCAL MACHINE\System\CurrentControlSet\Services\Tcpip\Parameters", RegName,
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class KeepAliveTimeController
    {
        public KeepAliveTimeController(KeepAliveTime keepAliveTime,
                                                         IKeepAliveTimeStrategy strategy)
        {
            KeepAliveTime = keepAliveTime;
            Strategy = strategy;
        }

        public KeepAliveTime KeepAliveTime { get; set; }
        public IKeepAliveTimeStrategy Strategy { get; set; }

        public void Read()
        {
            KeepAliveTime.SetKeepAliveTimeValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(KeepAliveTime.GetKeepAliveTimeValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
